implementation module predefined_types;

import StdEnv;
import predef;

:: PredefinedType
	= {
		pt_type_name			:: !String
	,	pt_constructor_names	:: [String]
	};
	
:: PredefinedTypes 
	:== [PredefinedType];
	

PredefinedTypes :: PredefinedTypes;		
PredefinedTypes
	=> [list_type,real_type,int_type,unboxed_array];
where {
	list_type
		= {
			pt_type_name			= PD_ListType_String
		,	pt_constructor_names	= [PD_ConsSymbol_String,PD_NilSymbol_String]
		};
	real_type
		= {
			pt_type_name			= "Real"
		,	pt_constructor_names	= ["REAL"]
		};
		
	int_type
		= {
			pt_type_name			= "Int"
		,	pt_constructor_names	= ["INT"]
		};
		
	unboxed_array
		= {
			pt_type_name			= PD_UnboxedArray_String
		,	pt_constructor_names	= ["_ARRAY_"]
		};
	
		
};